/* AMX MOD X script. 
*
*    Weapon Storage version 1.1, by KinSprite
*
* [Description]:
* 
*	   With this plugin, you can drop a weapon model that can provide a number of weapons each round. 
*
*	   When a player touch this entity, he may get a weapon/item on condition that such as touch 
*	a weapon in fy_iceworld. Also, you can set the cvar to allow multi weapons .
*
*	   A storage has two parameters . 1, belong to which team (Terrorist, CT or All teams); 2, provide 
*	how many weapons in this model.
*
*	   You can save these options in map config file loaded when change map.
*
*	   The menu command "ws_menu" is powerful. You can drop a storage in front of you ; remove a storage 
*	aimed at; remove all storages in the map; clear storage options saved in the map config file.
*
*
* [Required Modules]:
*
*	1. Engine
*	2. Fun
*	3. Cstrike
*
* [Installation]:
* 
*	1. copy weaponstorage.sam to "addons/amxmodx/amxmodx/scripting"; "weaponstorage.txt" to "<amxx_datadir> (default is "addons/amxmodx/data")/lang"
*	2. compile weaponstorage.sam
*	3. copy "addons/amxmodx/scripting/compiled/weaponstorage.amxx" to <amxx_pluginsdir> (default is "addons/amxmodx/plugins")
*	4. in <amxx_plugins> (default is "addons/amxmodx/configs/plugins.ini") add a line "weaponstorage.amxx"
*	5. in "<amxx_configsdir>(default is "addons/amxmodx/configs")/amxx.cfg" config the Cvars.
*
* [Commands]:
*	
*	[Admin CMD]
*
*	ws_menu
*		// - Show Weapon Storage Menu
*
*	amx_weaponstorage_menu
*		// - Show Weapon Storage Menu, the same as "ws_menu"
*
*	amx_weaponstorage_drop
*		// - Drop weapons in world and Save for the map?
*		// [USAGE]: amx_weaponstorage_drop <wpnID> <team> <amount> [SAVE]
*
*	amx_weaponstorage_clear
*		// - Clear weapon storages in the map
*
*	amx_weaponstorage_clmapcfg
*		// - Clear weapon storages' option in the map config file
*
*	
*	[Server CMD]
*
*	amx_createweaponstorage
*		// - Drop weapons in world
*		// amx_createweaponstorage <wpnID> <team> <amount> <Float:Origin[3]> <Float:Angles[3]> 
*
* [Cvars]:
*
*	amx_weaponstorage "1"
*		// Use this plugin's effect. To disable, set to 0
*	amx_weaponstorage_allowmulti "0"
*		// allow muti weapons, set to 1
*	amx_weaponstorage_c4ct "0"
*		// allow CT pick up C4 in C4 storage, set to 1 
*	amx_weaponstorage_ctplant "0"
*		// allow CT plant C4 when pick up C4 in C4 storage, set 1
*	amx_weaponstorage_kitt "0"
*		// allow Terrorist pick up defuse kit in kit storage, set 1
* 
* [Log]:
* 
*   v1.1, add item Nightvision Goggles
*         use cs_get_user_shield() instead of custom stock function.
*         use register_touch() instead of pfn_touch(), and optimize this function.
*         use static flag ADMIN_IMMUNITY instead.
*
*   v1.0, finished on 9/18, 2006
*	
*	
*/

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fun>
#include <cstrike>


new const PLUGIN_NAME[] = "Weapon Storage"
new const PLUGIN_VERSION[] = "1.1"
new const PLUGIN_AUTHOR[] = "KinSprite"

#define CSW_SHIELD 2
#define ITEM_NVG 33
#define ITEM_DEFUSEKIT 34
#define ITEM_LONGJUMP 35
#define ITEM_MEDICALKIT 36
#define ITEM_BATTERY 37

#define NROFITEMS 38

// Globals
new const WEAPONNAME[NROFITEMS][] = {
	"",				             	//  0 First should be empty
	"SIG P228",                     //  1 CSW_P228
	"Tactical Shield",		      	//  2 shield
	"Steyr Scout",			     	//  3 CSW_SCOUT
	"HE Grenade",		        	//  4 CSW_HEGRENADE
	"Benelli XM1014",				//  5 CSW_XM1014
	"C4 Time Bomb",			    	//  6 CSW_C4
	"Ingram MAC-10",				//  7 CSW_MAC10
	"Steyr Aug",			       	//  8 CSW_AUG
	"Smoke Grenade",			    //  9 CSW_SMOKEGRENADE
	"Dual Beretta 96G Elite",		// 10 CSW_ELITE
	"FN Five-Seven",				// 11 CSW_FIVESEVEN
	"H&K UMP45",                    // 12 CSW_UMP45
	"Sig SG-550 Sniper",			// 13 CSW_SG550
	"Galil",                        // 14 CSW_GALIL
	"Famas",                        // 15 CSW_FAMAS
	"H&K USP .45 Tactical",         // 16 CSW_USP
	"Glock18 Select Fire",          // 17 CSW_GLOCK18
	"AI Arctic Warfare/Magnum",     // 18 CSW_AWP
	"H&K MP5-Navy",                 // 19 CSW_MP5NAVY
	"FN M249 Para",                 // 20 CSW_M249
	"Benelli M3 Super90",           // 21 CSW_M3
	"Colt M4A1 Carbine",            // 22 CSW_M4A1
	"Steyr Tactical Machine Pistol",// 23 CSW_TMP
	"H&K G3/SG-1 Sniper Rifle",     // 24 CSW_G3SG1
	"Flashbang",			        // 25 CSW_FLASHBANG
	"Desert Eagle .50AE",           // 26 CSW_DEAGLE
	"Sig SG-552 Commando",          // 27 CSW_SG552
	"AK-47",                        // 28 CSW_AK47
	"Knife",			         	// 29 CSW_KNIFE
	"FN P90",                       // 30 CSW_P90
	"Kevlar Vest",			    	// 31 CSW_VEST
	"Kevlar Vest & Helmet",			// 32 CSW_VESTHELM
	"Nightvision Goggles",          // 33 item Nightvision Goggles
	"Defuse Kit",		        	// 34 defuser
	"Long Jump",			        // 35 item Long Jump
	"Medical Kit",			        // 36 item Medical Kit
	"Battery"                       // 37 item battery
};


new const WEAPONSTRINGS[NROFITEMS][] = {
	"",					// 0 First should be empty
	"weapon_p228",
	"weapon_shield",			// 2 shield
	"weapon_scout",
	"weapon_hegrenade",			// 4 CSW_HEGRENADE
	"weapon_xm1014",
	"weapon_c4",				// 6 CSW_C4
	"weapon_mac10",
	"weapon_aug",
	"weapon_smokegrenade",			// 9 CSW_SMOKEGRENADE
	"weapon_elite",
	"weapon_fiveseven",			
	"weapon_ump45",
	"weapon_sg550",
	"weapon_galil",
	"weapon_famas",
	"weapon_usp",
	"weapon_glock18",
	"weapon_awp",
	"weapon_mp5navy",
	"weapon_m249",
	"weapon_m3",
	"weapon_m4a1",
	"weapon_tmp",
	"weapon_g3sg1",
	"weapon_flashbang",			// 25 CSW_FLASHBANG
	"weapon_deagle",
	"weapon_sg552",
	"weapon_ak47",
	"weapon_knife",				// 29 CSW_KNIFE
	"weapon_p90",
	"item_kevlar",				// 31 CSW_VEST
	"item_assaultsuit",			// 32 CSW_VESTHELM
	"",                         // 33 item Nightvision Goggles
	"item_thighpack",			// 34 defuser
	"item_longjump",			// 35 item Long Jump
	"item_healthkit",			// 36 item Medical Kit
	"item_battery"              // 37 item battery
};

new const WEAPONMODEL[NROFITEMS][] = {
	"",		                  	// 0 First should be empty
	"w_p228",
	"w_shield",				    // 2 shield
	"w_scout",
	"w_hegrenade",				// 4 CSW_HEGRENADE
	"w_xm1014",	
	"w_backpack",				// 6 CSW_C4
	"w_mac10",
	"w_aug",
	"w_smokegrenade",			// 9 CSW_SMOKEGRENADE
	"w_elite",
	"w_fiveseven",
	"w_ump45",
	"w_sg550",
	"w_galil",
	"w_famas",
	"w_usp",
	"w_glock18",
	"w_awp",
	"w_mp5",
	"w_m249",
	"w_m3",
	"w_m4a1",
	"w_tmp",
	"w_g3sg1",
	"w_flashbang",				// 25 CSW_FLASHBANG
	"w_deagle",
	"w_sg552",
	"w_ak47",
	"w_knife",				    // 29 CSW_KNIFE
	"w_p90",
	"w_kevlar",				    // 31 CSW_VEST
	"w_assault",				// 32 CSW_VESTHELM
	"p_tripmine",               // 33 item Nightvision Goggles
	"w_thighpack",				// 34 defuser
	"w_longjump",			    // 35 item Long Jump
	"w_medkit",				    // 36 item Medical Kit
	"w_battery"                 // 37 item battery
};

new const AMMO_IN_BACKPACK[NROFITEMS] = {
	0,					//  0 First should be empty
	52,					//  1 CSW_P228
	0,					//  2 shield
	90,					//  3 CSW_SCOUT
	0,					//  4 CSW_HEGRENADE
	32,					//  5 CSW_XM1014
	0,					//  6 CSW_C4
	100,				//  7 CSW_MAC10
	90,					//  8 CSW_AUG
	0,					//  9 CSW_SMOKEGRENADE
	120,				// 10 CSW_ELITE
	100,				// 11 CSW_FIVESEVEN
	100,				// 12 CSW_UMP45
	90,					// 13 CSW_SG550
	90,					// 14 CSW_GALIL
	90,					// 15 CSW_FAMAS
	100,				// 16 CSW_USP
	120,				// 17 CSW_GLOCK18
	30,					// 18 CSW_AWP
	120,				// 19 CSW_MP5NAVY
	200,				// 20 CSW_M249
	32,					// 21 CSW_M3
	90,					// 22 CSW_M4A1
	120,				// 23 CSW_TMP
	90,					// 24 CSW_G3SG1
	0,					// 25 CSW_FLASHBANG
	35,					// 26 CSW_DEAGLE
	90,					// 27 CSW_SG552
	90,					// 28 CSW_AK47
	0,					// 29 CSW_KNIFE
	100,				// 30 CSW_P90
	0,					// 31 CSW_VEST
	0,					// 32 CSW_VESTHELM
	0,                  // 33 item Nightvision Goggles
	0,					// 33 defuser
	0,					// 34 item Long Jump
	0,					// 35 item Medical Kit
	0                   // 36 item battery
};

#define AMOUNT_LSTT_LEN 12
new const AMOUNT_LIST[AMOUNT_LSTT_LEN] = {1, 2, 4, 6, 8, 12, 16, 24, 32, 48, 64, 100};

//#define MeNU_ITEM_KEYS 5
new const MeNU_ITEM_KEYS = 5

//#define  MENU_TOTAL_PAGE (NROFITEMS/ MeNU_ITEM_KEYS + ((NROFITEMS % MeNU_ITEM_KEYS) ? 1 : 0 ))
new const MENU_TOTAL_PAGE = 8

#define WPNSTORAGE_CLASSNAME "weaponstorage"

new const MENU_CMD_SHORT[] = "ws_menu"
new const MENU_CMD[] = "amx_weaponstorage_menu"
new const ADMIN_CMD[] = "amx_weaponstorage_drop"
new const CLEAR_CMD[] = "amx_weaponstorage_clear"
new const CLEAR_MAPCFG[] = "amx_weaponstorage_clmapcfg"
new const SERVER_CMD[] = "amx_createweaponstorage"

new bool:g_haslongjump[33]

new g_menuPosition[33]
new g_menuOption_team[33]
new g_menuOption_amount[33]
new bool:g_menuOption_save[33]
new bool:g_menuOption_del[33]

new g_weaponstorage
new g_weaponstorage_allowmulti
new g_weaponstorage_c4ct
new g_weaponstorage_ctplant
new g_weaponstorage_kitt

new g_shield

public plugin_init() {
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_dictionary("weaponstorage.txt")
	
	register_clcmd(MENU_CMD_SHORT, "weaponstorage_menu", ADMIN_IMMUNITY, " - Show Weapon Storage Menu")
	register_clcmd(MENU_CMD, "weaponstorage_menu", ADMIN_IMMUNITY, " - Show Weapon Storage Menu")
	register_clcmd(ADMIN_CMD, "cmd_dropwpn", ADMIN_IMMUNITY, "<wpnID> <team> <amount> [SAVE] - Drop weapons in world and Save for the map?")
	register_concmd(CLEAR_CMD, "cmd_clear_storages", ADMIN_IMMUNITY, "- Clear weapon storages in the map")
	register_concmd(CLEAR_MAPCFG, "cmd_clear_mapcfg", ADMIN_IMMUNITY, "- Clear weapon storages' option in the map config file")
	
	register_srvcmd(SERVER_CMD, "svr_createweaponstorage", -1, "<wpnID> <team> <amount> <Float:Origin[3]> <Float:Angles[3]> - Drop weapons in world")
	
	register_event("Damage", "on_Damage", "b", "2!0") // check killed by C4 bomb
	register_event("DeathMsg","on_DeathMsg","a","2!0")
	register_event("TextMsg","restart_game","a","2&#Game_will_restart_in")
	register_logevent("reset_storage", 2, "1=Round_Start") 		// freezetime complete
	
	register_touch(WPNSTORAGE_CLASSNAME, "player", "touch_storage")
	
	register_menucmd(register_menuid("Choose Menu or Command  "), MENU_KEY_1|MENU_KEY_2|MENU_KEY_6|MENU_KEY_7|MENU_KEY_0, "_weaponstorage_menu")
	register_menucmd(register_menuid("Create Weapon Storage   "), 1023, "_create_storage_menu")
	register_menucmd(register_menuid("Remove Weapon Storage   "), MENU_KEY_1 | MENU_KEY_6 | MENU_KEY_0, "_remove_storage_menu")
	
	g_weaponstorage =  register_cvar("amx_weaponstorage", "1")  	// Use this plugin's effect. To disable, set to 0
	g_weaponstorage_allowmulti =  register_cvar("amx_weaponstorage_allowmulti", "0") // muti weapons
	g_weaponstorage_c4ct =  register_cvar("amx_weaponstorage_c4ct", "0")
	g_weaponstorage_ctplant = register_cvar("amx_weaponstorage_ctplant", "0")
	g_weaponstorage_kitt = register_cvar("amx_weaponstorage_kitt", "0")
	
	g_shield = file_exists("models/p_shield.mdl") & file_exists("models/w_shield.mdl")
}

public plugin_precache() {
	precache_model("models/w_longjump.mdl")
	precache_model("models/w_medkit.mdl")
	precache_model("models/w_battery.mdl")
	precache_model("models/p_tripmine.mdl")
	
	precache_sound("items/smallmedkit1.wav")
}


//////////////////////////////////////////////////////////
///                   Events                           ///
//////////////////////////////////////////////////////////

public on_Damage(victim){
	if (get_pcvar_num(g_weaponstorage))
		return PLUGIN_CONTINUE
		
	if ( victim < 1 || victim > 32 )
		return PLUGIN_CONTINUE
		
	if (!g_haslongjump[victim])
		return PLUGIN_CONTINUE
		
	new wpnindex = 0, hitplace = 0, attacker = get_user_attacker(victim,wpnindex,hitplace)
	new damage = read_data(2)
	
	call_damage(victim, attacker, damage, wpnindex, hitplace)
	
	return PLUGIN_CONTINUE
}


public call_damage(victim, attacker, damage, wpnindex, hitplace){	
	new inflictor = entity_get_edict(victim, EV_ENT_dmg_inflictor)
	
	// Check to see if the damage was from the bomb
	if(wpnindex != 4 && attacker != victim && inflictor > 0 ){
		
		if ( is_valid_ent ( inflictor ) )
		{
			new szClassName[64]
			entity_get_string(inflictor, EV_SZ_classname, szClassName, 63)	
				
			// Technically I don't think we need to check the classname, but just in case
			if ( equali(szClassName, "grenade") || equali(szClassName, "env_explosion") ){

				// We need to call the death function manually b/c DeathMsg isn't broadcasted when the bomb explodes and kills someone
				if (get_user_health(victim) - damage < 0 ){
					g_haslongjump[victim] = false
				}	
			}	
		}
	}
	
	return PLUGIN_CONTINUE
}

public on_DeathMsg() {
	if (get_pcvar_num(g_weaponstorage))
		g_haslongjump[read_data(2)] = false
		
	return PLUGIN_CONTINUE
}

public client_putinserver(id) {
	if (get_pcvar_num(g_weaponstorage))
		g_haslongjump[id] = false
		
	return PLUGIN_CONTINUE
}

public restart_game() {
	if (get_pcvar_num(g_weaponstorage))
		for (new i = 0; i < 33; ++i)
			g_haslongjump[i] = false
		
	reset_storage()
	
	return PLUGIN_CONTINUE
}

// Round Start
public reset_storage() {
	if (!get_pcvar_num(g_weaponstorage)) {
		clear_all_entity(WPNSTORAGE_CLASSNAME)
		return PLUGIN_CONTINUE
	}
	
	new wpnmodel[32]
	
	new ent = find_ent_by_class(-1, WPNSTORAGE_CLASSNAME)
	while (ent) {
		format(wpnmodel, 31, "models/%s.mdl", WEAPONMODEL[entity_get_int(ent, EV_INT_iuser1)])	
		entity_set_model(ent, wpnmodel)
		entity_set_int(ent, EV_INT_iuser3, entity_get_int(ent, EV_INT_iuser2))
		ent = find_ent_by_class(ent, WPNSTORAGE_CLASSNAME)
	}
	
	return PLUGIN_CONTINUE
}

public touch_storage(ent, player) {
	if (!get_pcvar_num(g_weaponstorage))
		return PLUGIN_CONTINUE
			
	new contain_amount = entity_get_int(ent, EV_INT_iuser3)
	
	if (contain_amount) {
		new is_team = entity_get_int(ent, EV_INT_team) & get_user_team(player)
		
		if (!is_team) {
			client_print(player, print_center, "%L", player, "NOT_FOR_YOUR_TEAM")
			return PLUGIN_CONTINUE
		}
			
		new wpn = entity_get_int(ent, EV_INT_iuser1)
		
		if (give_wpn(player, wpn)){
			entity_set_int(ent, EV_INT_iuser3, contain_amount - 1)
			
			if (contain_amount == 1)                // contain_amount - 1 = 0
				entity_set_model(ent, "")           // No model
		}
	}
	
	return PLUGIN_CONTINUE
}


/////////////////////////////////////////////////
//                Server CMD                   //
/////////////////////////////////////////////////

public svr_createweaponstorage(){
	if (read_argc() < 10) {
		server_print("[Usage]: ^"%s <wpnID> <team> <amount> <Float:Origin[3]> <Float:Angles[3]>^"", SERVER_CMD)
		return PLUGIN_HANDLED
	}
	
	new wpn, team, amount, Float:origin[3], Float:angle[3]
	new arg[16], Float:temp, i
	for (i = 1; i < 9; ++i) {
		read_argv(i, arg, 15)
		switch (i) {
			case 1: wpn = str_to_num(arg);
			case 2: team = str_to_num(arg);
			case 3: amount = str_to_num(arg);
			default : temp = str_to_float(arg);
		}
		
		if (i > 3 && i < 7)
			origin[i-4] = temp
		else if (i > 6)
			angle[i-7] = temp
	}
	
	if (!g_shield && (wpn == CSW_SHIELD || wpn == CSW_FAMAS || wpn == CSW_GALIL)) {
		server_print("*** [Fail]: Can't create ^"%s^" in the game",  WEAPONNAME[wpn])
		return PLUGIN_HANDLED
	}
	
	create_wpn(wpn, team, amount, origin, angle)
	
	return PLUGIN_HANDLED
}


/////////////////////////////////////////////////
//                Admin CMDs                   //
/////////////////////////////////////////////////

public cmd_dropwpn(id,level,cid) {
	if (!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED
		
	if (!get_pcvar_num(g_weaponstorage))
		return PLUGIN_HANDLED
	
	new arga[32],argb[32], argc[32], argd[32]
	
	read_argv(1, arga, 31)
	read_argv(2, argb, 31)
	read_argv(3, argc, 31)
	read_argv(4, argd, 31)
	
	new wpn = str_to_num(arga)
	new team = str_to_num(argb)
	new amount = str_to_num(argc)
	
	if (wpn < 1 || wpn >= NROFITEMS || amount < 1) {
		print_help(id)
		return PLUGIN_HANDLED
	}
	
	if (!g_shield && (wpn == CSW_SHIELD || wpn == CSW_FAMAS || wpn == CSW_GALIL)) {
		console_print(id, "%L", id, "FAIL_CREATE_WPN", WEAPONNAME[wpn])
		return PLUGIN_HANDLED
	}

	if (team !=1 && team !=2)
		team = 3
	
	new Float:origin[3], Float:angle[3]
	get_wpnorigin(id, origin, angle)
	
	create_wpn(wpn, team, amount, origin, angle)
	
	new is_save
	
	if (equali(argd, "save") || str_to_num(argd)) {
		new mapname[32]
		get_mapname(mapname, 31)
		
		if (save_WPNforMap(wpn, team, amount, origin, angle)) {
			is_save = 1
			console_print(id, "%L", id, "SUCCESS_WRITE_MAPCFG", mapname)
		} 
		else
			console_print(id, "%L", id, "FAIL_WRITE_MAPCFG", mapname)
	}
	
	log_admin_action(id, wpn, team, amount, is_save, origin, angle)
	
	return PLUGIN_HANDLED
}

public cmd_clear_storages(id, level, cid) {
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
		
	clear_storages(id)
	
	return PLUGIN_HANDLED
}

public cmd_clear_mapcfg(id, level, cid) {
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
		
	clear_mapcfg(id)
	
	return PLUGIN_HANDLED
}


//////////////////////////////////////////////////////////
///                    Menus                           ///
//////////////////////////////////////////////////////////

public weaponstorage_menu(id, level, cid) {	
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
		
	if (!get_pcvar_num(g_weaponstorage))
		return PLUGIN_HANDLED
		
	new keys = (1<<0) | (1<<1) | (1<<5) | (1<<6) | (1<<9)  // MENU_KEY_1 | MENU_KEY_2 | MENU_KEY_6 | MENU_KEY_7 | MENU_KEY_0
	
	new menuBody[512]
	
	new len = format(menuBody, 511, "\y%L^n^n", id, "CHOOSE_MENU_COMMAND")
	
	len += format(menuBody[len], 511 - len, "\w1. %L^n2. %L^n^n", id, "CREATE_STORAGE_MENU", id, "REMOVE_STORAGE_MENU")
	len += format(menuBody[len], 511 - len, "\y6. %L^n7. %L^n^n", id, "CLEAR_ALL_STORAGE", id, "CLEAR_ALL_STORAGE_OPTION")
	len += format(menuBody[len], 511 - len, "\w0. %L", id, "EXIT")
	
	show_menu(id, keys, menuBody, -1, "Choose Menu or Command  ")
	
	return PLUGIN_HANDLED
}

public _weaponstorage_menu(id, key) {
	switch (key) {
		case 0: {
			g_menuOption_team[id] = 3 // 1 - T, 2 - CT, 3 - all team
			g_menuOption_amount[id] = 0
			g_menuOption_save[id] = false
			
			create_storage_menu(id, g_menuPosition[id] = 0)
		}
		case 1: {
			g_menuOption_del[id] = false
			
			remove_storage_menu(id)
		}
		case 5: clear_storages(id)
		case 6: clear_mapcfg(id)
		default : return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}


public create_storage_menu(id, pos) {
	new menuBody[512]
	new b = 0
	new start = pos * MeNU_ITEM_KEYS + 1 // WEAPONNAME[0] is empty
	if (start >= NROFITEMS) {
		pos = g_menuPosition[id] = 0
		start = 1
	}
	
	new len = format(menuBody, 511, "\y%L\R%d/%d^n\w^n", id, "CREATE_STORAGE", pos + 1, MENU_TOTAL_PAGE)
	new end = start + MeNU_ITEM_KEYS
	new keys = (1<<5) | (1<<6) | (1<<7) | (1<<8) | (1<<9) 	//key 6 - Option_team, key 7 - Option_amount, key 8 - Option_save, key 9 - More or Start page, key 0 - Back or Exit
	
	if (end > NROFITEMS)
		end = NROFITEMS
		
	for (new a = start; a < end; ++a){
		keys |= (1<<b)
		len += format(menuBody[len], 511-len, "\w%d. %s^n\w", ++b, WEAPONNAME[a])
	}
	
	new team, store_string[16]
	team = g_menuOption_team[id]
	switch (team) {
		case 1: store_string = "STORE_FOR_T"
		case 2: store_string = "STORE_FOR_CT"
		case 3: store_string = "STORE_FOR_ALL"
	}
	
	len += format(menuBody[len],511-len, "^n6. %L^n\y7. %L: %d^n", id, store_string, id, "STORE_AMOUNT", AMOUNT_LIST[g_menuOption_amount[id]]) // key 6, key 7
	
	len += format(menuBody[len],511-len,"\r8. %L^n\w", id, g_menuOption_save[id] ? "SAVE_FOR_MAP" : "DONNOT_SAVE_FOR_MAP") // key 8
	
	format(menuBody[len],511-len,"^n9. %L^n0. %L", id, (pos < MENU_TOTAL_PAGE - 1) ? "MORE" : "START_PAGE", id, pos ? "BACK" : "EXIT")
		
	show_menu(id, keys, menuBody, -1, "Create Weapon Storage   ")
	
	return PLUGIN_CONTINUE
}

public _create_storage_menu(id, key) {
	switch(key){
		case 5: {	// key 6
			++g_menuOption_team[id]
			if (g_menuOption_team[id] > 3)
				g_menuOption_team[id] = 1
			
			create_storage_menu(id, g_menuPosition[id])
		}
		case 6: { 	// key 7
			++g_menuOption_amount[id]
			if (g_menuOption_amount[id] >= AMOUNT_LSTT_LEN)
				g_menuOption_amount[id] = 0
				
			create_storage_menu(id, g_menuPosition[id])
		}   
		case 7:	 {	// key 8
			if (g_menuOption_save[id])
				g_menuOption_save[id] = false
			else
				g_menuOption_save[id] = true
				
			create_storage_menu(id, g_menuPosition[id])
		}
		case 8:	 create_storage_menu(id, ++g_menuPosition[id])	// key 9
		case 9: {	// key 0
			if (g_menuPosition[id] > 0)	
				create_storage_menu(id, --g_menuPosition[id])
			else
				return PLUGIN_HANDLED
		}
		default:{
			new wpn = g_menuPosition[id] * MeNU_ITEM_KEYS + key + 1
			
			if (!g_shield && (wpn == CSW_SHIELD || wpn == CSW_FAMAS || wpn == CSW_GALIL)) {
					client_print(id, print_center, "%L", id, "FAIL_CREATE_WPN_CENTER", WEAPONNAME[wpn])
			}
			else {
				new team = g_menuOption_team[id]
				new amount = AMOUNT_LIST[g_menuOption_amount[id]]
				
				new Float:origin[3], Float:angle[3]
				
				get_wpnorigin(id, origin, angle)
				create_wpn(wpn, team, amount, origin, angle)
				
				new is_save
				
				if (g_menuOption_save[id]) {
					new mapname[32]
					get_mapname(mapname, 31)
				
					if (save_WPNforMap(wpn, team, amount, origin, angle)) {
						is_save = 1
						client_print(id, print_chat, "%L", id, "SUCCESS_WRITE_MAPCFG", mapname)
					} 
					else
						client_print(id, print_chat,  "%L", id, "FAIL_WRITE_MAPCFG", mapname)
				}
				
				log_admin_action(id, wpn, team, amount, is_save, origin, angle)
			}
			
			create_storage_menu(id, g_menuPosition[id])
		}
	}
	
	return PLUGIN_HANDLED
}

public remove_storage_menu(id) {

	new keys = (1<<0) | (1<<5) | (1<<9)  // MENU_KEY_1 | MENU_KEY_6 | MENU_KEY_0
	
	new menuBody[512]
	
	new len = format(menuBody, 511, "\y%L^n^n", id, "REMOVE_STORAGE")
	len += format(menuBody[len], 511 - len, "\w1. %L^n^n", id, "REMOVE_YOU_AIM_AT")
	len += format(menuBody[len], 511 - len, "\y6. %L^n^n^n\w0. %L", id, g_menuOption_del[id] ? "REMOVE_ADD_DEL_OPTION" : "REMOVE_BUT_NOT_DEL_OPTION", id, "EXIT")
	
	show_menu(id, keys, menuBody, -1, "Remove Weapon Storage   ")
	
	return PLUGIN_CONTINUE
}

public _remove_storage_menu(id, key) {
	switch (key) {
		case 0: {
			remove_storage_by_aim(id, g_menuOption_del[id])
			
			remove_storage_menu(id)
		}
		case 5: {
			if (g_menuOption_del[id])
				g_menuOption_del[id] = false
			else 
				g_menuOption_del[id] = true
				
			remove_storage_menu(id)
		}
		default : return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}


//////////////////////////////////////////////////////////
///              Common Functions                      ///
//////////////////////////////////////////////////////////

clear_all_entity(classname[]) {
	new ent = find_ent_by_class(-1, classname)
	while (ent) {
		entity_set_int(ent, EV_INT_flags, entity_get_int(ent, EV_INT_flags) | FL_KILLME)
		ent = find_ent_by_class(ent, classname)
	}
}

print_help(id) {
	console_print(id, "%L", id, "PLUGIN_INFO", PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	
	new table[24]
	format(table, 23, "%L", id, "WEAPON_TABLE")
	
	new temp[128], len, i
	for (i = 0; i <3; ++i)
		len += format(temp[len], 127 - len, "%20s", table)
	console_print(id, temp)
	
	len = 0
	for (i = 1; i < 34; ++i) {
		len += format(temp[len], 127 - len, "#%2d - %18s", i, WEAPONNAME[i])
		if (i % 3 == 0) {
			console_print(id, temp)
			len = 0
		}
	}
	
	console_print(id, "[%L]: ", id, "USAGE")
	console_print(id, "1. ^"%s <wpnID> <team> <amount>^" : %L", ADMIN_CMD, id, "ADMIN_CMD_USAGE_1")
	console_print(id, "2. ^"%s <wpnID> <team> <amount> save^" : %L", ADMIN_CMD, id, "ADMIN_CMD_USAGE_2")
	console_print(id, "%L : 1. ^"%s 5 1 20^" 2. ^"%s 5 1 20 save^"", id, "SUCH_AS", ADMIN_CMD, ADMIN_CMD)
	console_print(id, "================================================")
}

create_wpn(wpn, team, amount, Float:Origin[3], Float:Angle[3]) {
	new ent = create_entity("info_target")
	entity_set_string(ent, EV_SZ_classname, WPNSTORAGE_CLASSNAME)  // class name
	
	new wpnmodel[32]
	format(wpnmodel, 31, "models/%s.mdl", WEAPONMODEL[wpn])    // model name
		
	entity_set_model(ent, wpnmodel)
	entity_set_origin(ent, Origin)
  
	entity_set_int(ent, EV_INT_movetype, 6)
	entity_set_int(ent, EV_INT_solid, 1)
	entity_set_int(ent, EV_INT_iuser1, wpn)
	entity_set_int(ent, EV_INT_iuser2, amount)	// max store amount
	entity_set_int(ent, EV_INT_iuser3, amount)  // contain amount
	
	entity_set_int(ent, EV_INT_team, team)
	
	entity_set_vector(ent, EV_VEC_angles, Angle)
}

save_WPNforMap(wpn, team, amount, Float:Origin[3], Float:Angle[3]) {
	new mapcfg_dir[160]
	get_mapcfg_dir(mapcfg_dir, 159)
	
	new status = dir_exists(mapcfg_dir)
	
	if (!status) {
		log_amx("Faile to open dir ^"%s^"", mapcfg_dir)
		return false
	}
	else {
	
		new map_cfg_text[256], map_cfg_path[160]
		format(map_cfg_text, 255, "%s %d %d %d %.2f %.2f %.2f %.2f %.2f %.2f (Item: ^"%s^")",\
		SERVER_CMD, wpn, team, amount, Origin[0], Origin[1], Origin[2], Angle[0], Angle[1], Angle[2], WEAPONNAME[wpn])
		
		get_mapcfg_filepath(map_cfg_path, 159)
		write_file(map_cfg_path, map_cfg_text, -1)
		
		log_amx("wirte text ^"%s^" to map config file", map_cfg_text)
	}
	return true
}

log_admin_action(id, wpn, team, amount, save, Float:origin[3], Float:Angle[3]) {
	new name[32], mapname[32]
	get_user_name(id, name, 31)
	get_mapname(mapname, 31)
	
	new team_string[16], team_lang[16]
	switch (team) {
		case 1: team_string = "Terrorist", team_lang = "TEAM_T";
		case 2: team_string = "CT", team_lang = "TEAM_CT";
		case 3: team_string = "All teams", team_lang = "TEAM_ALL";
	}
	
	log_amx("Admin: ^"%s^" create ^"%s^" for ^"%s^" on map ^"%s^"(Amount: %d ; Origin: %.2f, %.2f, %.2f ; Angle: %.2f, %.2f, %.2f)%s",\
		name, WEAPONNAME[wpn], team_string, mapname, amount, origin[0], origin[1], origin[2], Angle[0], Angle[1], Angle[2], save ? "" : ".")
	
	new Players[32] 
	new playerCount, i
	get_players(Players, playerCount, "c") 
	

	switch (get_cvar_num("amx_show_activity")) {
		case 2: {
			for (i=0; i<playerCount; ++i) {
				format( team_string, 15, "%L", Players[i], team_lang)
				client_print(Players[i] , print_chat, "%L", Players[i] , save ? "LOG_ADMIN_SAVE_2" : "LOG_ADMIN_2", PLUGIN_NAME, name, WEAPONNAME[wpn], team_string, amount)
			}
		}
		case 1: {
			for (i=0; i<playerCount; ++i) {
				format( team_string, 15, "%L", Players[i], team_lang)
				client_print(Players[i] , print_chat, "%L", Players[i] , save ? "LOG_ADMIN_SAVE_1" : "LOG_ADMIN_1", PLUGIN_NAME, WEAPONNAME[wpn], team_string, amount)
			}
		}
	}
}

// Give Weapn Function. 
// if give item to player id, return true. else, return false
give_wpn(id, wpn) {
	new is_realWpn
	switch (wpn) {
		case CSW_SHIELD: {		// shield
			if (cs_get_user_hasprim(id) || user_has_weapon(id, CSW_ELITE))
				return false
		}
		case CSW_C4: {
			is_realWpn = 1
			if (get_user_team(id) != 1 && !get_pcvar_num(g_weaponstorage_c4ct))
				return false
		}
		case CSW_VEST: {
			if (get_user_armor(id) > 99)
				return false
		}
		case CSW_VESTHELM: {
			new CsArmorType:type
			new armor = cs_get_user_armor(id, type)
			
			if (type == CS_ARMOR_VESTHELM && armor > 99)
				return false
		}
		case ITEM_NVG: {
			if (cs_get_user_nvg(id))
				return false
			else {
					cs_set_user_nvg(id, 1)
					client_print(id, print_center, "%L", id, "PICK_UP_NVG")
					return true
			}
		}
		case ITEM_DEFUSEKIT: {       // defuser
			if (cs_get_user_defuse(id) || (get_user_team(id) != 2 && !get_pcvar_num(g_weaponstorage_kitt)))
				return false
		}
		case ITEM_LONGJUMP: {
			if (g_haslongjump[id])
				return false
		}
		case ITEM_MEDICALKIT: {
			if (get_user_health(id) > 99)
				return false
		}
		case ITEM_BATTERY: {
			if (get_user_armor(id) > 99)
				return false
		}
		default : is_realWpn = 1
	}
	
	if (wpn == CSW_FLASHBANG) {
		if (user_has_weapon(id, wpn)) {
			new in_clip, in_backpack
			get_user_ammo(id, CSW_FLASHBANG, in_clip, in_backpack)
			if (in_backpack == 2)
				return false
			else {
				give_item(id, WEAPONSTRINGS[wpn]) 
				user_has_weapon(id, CSW_FLASHBANG, 1)
				cs_set_user_bpammo(id, CSW_FLASHBANG, 2)
				return true
			}
		}
		give_item(id, WEAPONSTRINGS[wpn]) 
		user_has_weapon(id, CSW_FLASHBANG, 1)
		cs_set_user_bpammo(id, CSW_FLASHBANG, 1)
		return true
	}
	
	if (!get_pcvar_num(g_weaponstorage_allowmulti)) { // control muti weapons
		if (isPrimary(wpn)){
			if (cs_get_user_hasprim(id))
				return false
		}		
		else if (isSecondary(wpn)){
			if(has_secwpn(id))
				return false
			else 
				if (g_shield)
					if (wpn == CSW_ELITE && cs_get_user_shield(id))
						return false
		}
	}
	
	if (is_realWpn)				// not give the weapon if player already has it
		if (user_has_weapon(id, wpn))
			return false
			
	give_item(id, WEAPONSTRINGS[wpn])         // give item
	if (wpn == CSW_C4) {
		if (get_user_team(id) == 1)
			cs_set_user_plant(id, 1, 1)
		else if (get_pcvar_num(g_weaponstorage_ctplant))
			cs_set_user_plant(id, 1, 1)
	}else if (wpn == ITEM_DEFUSEKIT) {
		//if (get_user_team(id) == 2)
			cs_set_user_defuse(id,1, 0, 160, 0, "defuser", 0)
	} else if (wpn == ITEM_LONGJUMP) {
		g_haslongjump[id] = true
	}
	
	if (AMMO_IN_BACKPACK[wpn] != 0)
		cs_set_user_bpammo(id, wpn, AMMO_IN_BACKPACK[wpn])
		
	return true
}

remove_storage_by_aim(id, bool:del_mapOption) {
	new origin_temp[3] 
	get_user_origin(id, origin_temp, 3)
	
	new Float:origin[3]
	
	origin[0] =  float(origin_temp[0])
	origin[1] =  float(origin_temp[1])
	origin[2] =  float(origin_temp[2])
	new nearest, sz[32]
	new Float: min_distance = 9999.0 
	new Float: distance, Float: vector[3]
	
	new ent = find_ent_in_sphere ( -1, origin, 20.0 )
	
	while (ent) {
		if (is_valid_ent(ent)) {
			entity_get_string(ent, EV_SZ_classname, sz, 31)
			
			if (equal(sz, WPNSTORAGE_CLASSNAME)) {
				entity_get_vector(ent, EV_VEC_origin, vector)
				
				distance = get_distance_f(origin, vector)
				
				if (distance < min_distance) {
					min_distance = distance
					nearest = ent
				}
			}
		}
		
		ent = find_ent_in_sphere ( ent, origin, 20.0 )
	}
	
	if (nearest != 0) {
		new wpn = entity_get_int(nearest, EV_INT_iuser1)
	
		if (del_mapOption) {
			new path[160], cmd[64]
			get_mapcfg_filepath(path, 159)
			format(cmd, 63, "%s %d %d %d", SERVER_CMD, wpn, entity_get_int(nearest, EV_INT_team), entity_get_int(nearest, EV_INT_iuser2))
			
			entity_get_vector(nearest, EV_VEC_origin, vector)
			
			new del_lines = del_cmd_infile(path, cmd, true, vector)
			
			if (del_lines) {
				client_print(id, print_chat , "%L", id, "DEL_OPTION_MAPCFG", PLUGIN_NAME, del_lines)

				new name[32]
				get_user_name(id, name, 31)
					
				log_amx("Admin: ^"%s^" has deleted %d lines of the Weapon(^"%s^") storage's options ^"%s^" in the file ^"%s^"", name, del_lines, WEAPONNAME[wpn], cmd, path)
			}
		}
		
		entity_set_int(nearest, EV_INT_flags, entity_get_int(nearest, EV_INT_flags) | FL_KILLME)
		
		
		client_print(id, print_chat ,"%L", id, del_mapOption ? "REMOVE_STORAGE_2" : "REMOVE_STORAGE_1", PLUGIN_NAME, WEAPONNAME[wpn])
	}
}

clear_storages(id) {
	clear_all_entity(WPNSTORAGE_CLASSNAME)
	
	console_print(id, "%L", id, "ALL_STORAGES_CLEARED", PLUGIN_NAME)
	
	new name[32]
	if (id)
		get_user_name(id, name, 31)
	else 
		name = "SERVER CONSOLE"
		
	log_amx("Admin: ^"%s^" clears weapon storages in the map", name)
	
	switch (get_cvar_num("amx_show_activity")) {
		case 2: client_print(0, print_chat, "%L", LANG_PLAYER, "ADMIN_CLEAR_ALL_STORAGES_2", PLUGIN_NAME, name)
		case 1: client_print(0, print_chat, "%L", LANG_PLAYER, "ADMIN_CLEAR_ALL_STORAGES_1", PLUGIN_NAME)
	}
	
	return PLUGIN_HANDLED
}

clear_mapcfg(id) {	
	new path[160]
	
	get_mapcfg_dir(path, 159)
	if (!dir_exists(path))
		return PLUGIN_HANDLED
	
	get_mapcfg_filepath(path, 159)
	
	new cmd[32] 
	cmd = SERVER_CMD
	
	new del_lines = del_cmd_infile(path, cmd)
	
	if (!del_lines)
		return PLUGIN_HANDLED
	
	console_print(id, "%L", id, "CLEAR_ALL_STORAGE_OPTION_RESULT", PLUGIN_NAME, del_lines)
	
	new name[32]
	if (id)
		get_user_name(id, name, 31)
	else 
		name = "SERVER CONSOLE"
		
	log_amx("Admin: ^"%s^" has cleared the Weapon storage's options in the file ^"%s^" (Deleted %d lines)", name, path, del_lines)
	
	return PLUGIN_HANDLED
}

//////////////////////////////////////////////////////////
///                   Stocks                           ///
//////////////////////////////////////////////////////////
stock del_cmd_infile(filepath[], cmd[], bool: chk_dist = false, Float: vector[3] = {0.0, 0.0, 0.0}) {
	if (!file_exists(filepath))
		return 0

	new del_lines, line, curline, txtlen, is_exist
	new max_line = file_size(filepath, 1)
	new no_end = 1
	new text[128]
	
	new Float: origin[3]
	
	while (no_end) {
		curline = line
		line = read_file(filepath, line, text, 127, txtlen)
		is_exist = contain(text, cmd)
		
		if (is_exist != -1) {
			new is_cmdStart = 1
			
			for (new i = 0; i < is_exist; ++i)
				if (text[i] != ' ')
					is_cmdStart = 0
			
			if (is_cmdStart) {
				if (chk_dist) {
					for (new i = is_exist, counter = 0; text[i] != 0 && counter < 6; ++i) {
						if (text[i] == ' ' && text[i+1] != ' ') {
							++counter
							if (counter > 3)
								origin[counter-4] = str_to_float(text[i+1])
						}
					}
					
					origin[2] = vector[2]
					
					if (get_distance_f(vector, origin) < 30.0) {
						write_file(filepath,"",curline)
						++del_lines
					}
				}
				else {
					write_file(filepath,"",curline)
					++del_lines
				}
			}
		}
		
		if (line==0 || line==max_line)
			no_end = 0
	}
	
	return del_lines
}

stock get_wpnorigin(id, Float:Origin[3], Float:Angle[3]) {
	new Float:PlayerOrigin[3], Float:End[3], Float:TraceDirection[3]
	entity_get_vector(id, EV_VEC_origin, PlayerOrigin)
	VelocityByAim(id, 96, TraceDirection)

	End[0] = TraceDirection[0] + PlayerOrigin[0]
	End[1] = TraceDirection[1] + PlayerOrigin[1]
	End[2] = TraceDirection[2] + PlayerOrigin[2]

	trace_line(id, PlayerOrigin, End, Origin)
	Origin[2] = PlayerOrigin[2]
	
	entity_get_vector(id, EV_VEC_v_angle, Angle)
	Angle[0] = 0.0
	Angle[2] = 0.0
}

stock has_secwpn(id) {
	new Secondary[6] = {CSW_P228, CSW_ELITE, CSW_FIVESEVEN, CSW_USP, CSW_GLOCK18, CSW_DEAGLE};
	
	for (new i = 0; i < 6; ++i)
		if (user_has_weapon(id, Secondary[i]))
			return true
		
	return false
}

stock isPrimary(WPNid) {
	if (WPNid == CSW_SCOUT || WPNid == CSW_XM1014 || WPNid == CSW_MAC10 || 
		WPNid == CSW_AUG	|| WPNid == CSW_UMP45 || WPNid == CSW_SG550 || 
		WPNid == CSW_GALI || WPNid == CSW_FAMAS || WPNid == CSW_AWP || 
		WPNid == CSW_MP5NAVY || WPNid == CSW_M249 || WPNid == CSW_M3 ||
		WPNid == CSW_M4A1 || WPNid == CSW_TMP || WPNid == CSW_G3SG1 ||
		WPNid == CSW_SG552 || WPNid == CSW_AK47 || WPNid == CSW_P90) {
		return true
	}
	
	return false
}

stock isSecondary(WPNid) {
	if ( WPNid == CSW_P228 || WPNid == CSW_ELITE || WPNid == CSW_FIVESEVEN || 
		WPNid == CSW_USP || WPNid == CSW_GLOCK18 || WPNid == CSW_DEAGLE ) {
		return true
	}
	
	return false
}

stock get_mapcfg_dir(output[], len) {
	new cfg_path[128]
	get_configsdir(cfg_path,127)
	return format(output, len, "%s/maps", cfg_path)
}

stock get_mapcfg_filepath(output[], len) {
	new mapcfg_dir[160], mapname[32]
	get_mapcfg_dir(mapcfg_dir, 159)
	get_mapname(mapname, 31)
	return format(output, len, "%s/%s.cfg", mapcfg_dir, mapname)
}
